Attribute VB_Name = "MultiCombo"
'------------------------------------------------------------------
' Name : MultiComboBox
'
' Purpose : Give many functions to use the Microsoft Forms ComboBox
'           that can control many columns for each line.
'
' Methods:
'   1) MCombo_Fill          Fill a comboBox with the request send
'                           as parameter. The size of the sub list
'                           is automatically adapted to the data
'
'   2) MCombo_AddItemCode   Add an item with a code
'
'   3) MCombo_CodeSelect    Select an item with the code
'
'   4) MCombo_TextSelect    Select an item with the text
'                           (not recommanded)
'
'   5) MCombo_GetCode       Returns the code of the selected item
'
'   6) MCombo_LetCode       Set the code of the current item
'
' review : 15/Feb/2000 by AD
'------------------------------------------------------------------

Public Sub MCombo_Fill(cbo_Cbo As msforms.ComboBox, ls_Request As String, Optional lv_Language As Variant, Optional lb_OldLoad = OK)
'------------------------------------------------------------------
' Name : MCombo_Fill
'
' Purpose : Fill a combobox with the request send as parameter. The
'           size of the sub list is automatically adapted to the
'           data. The data of the request is limited to Code,
'           description, drop_flag and icon ID in this order.
'
' Parameters :
'       Cbo_cbo         The comboBox
'       ls_Request      The request that send the data
'       lv_Language     The language to use
'
' Return : Nothing
'
' review : 15/Feb/2000 by AD
'------------------------------------------------------------------
Dim ls_req As String
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ls_Code As String
Dim ls_Description As String
Dim li_colNumber As Integer
Dim ls_Font As String
Dim li_FontSize As String
Dim li_ScaleMode As Integer
Dim li_MaxSize As Integer
Dim li_CurrentSize As Integer
Dim li_ComboSize As Integer
Dim i As Integer

    On Error GoTo suite
    
    li_MaxSize = 0
        
    If IsMissing(lv_Language) Then lv_Language = gut_LangWork.Code
    Select Case ls_Request
            ' Simple query
    
            ' Special query
        Case Else: ls_req = ls_Request
    End Select
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req) Then
        li_Status = SQL_SUCCESS
        SQLNumResultCols ll_Statement, li_colNumber
        
        'Save the informations of the current form
        ls_Font = cbo_Cbo.Parent.Font.Name
        li_FontSize = cbo_Cbo.Parent.FontSize
        li_ScaleMode = cbo_Cbo.Parent.ScaleMode
        
        'Change the parameters of the form to another metric system
        li_ComboSize = cbo_Cbo.Parent.ScaleX(cbo_Cbo.Width, vbTwips, vbPoints)
        cbo_Cbo.Parent.Font = cbo_Cbo.Font
        cbo_Cbo.Parent.FontSize = cbo_Cbo.Font.Size
        cbo_Cbo.Parent.ScaleMode = vbPoints
        
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
            li_Status = SQLFetch(ll_Statement)
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
            
                'read the code
                ls_Code = ODBCData(ll_Statement, 1)
                'read the description
                ls_Description = ODBCData(ll_Statement, 2)
                
                'Verify if we must change the size of the combobox sublist
                li_CurrentSize = cbo_Cbo.Parent.TextWidth(ls_Description)
                If (li_CurrentSize > li_MaxSize) _
                  And (li_CurrentSize + 25 > li_ComboSize) Then
                    li_MaxSize = li_CurrentSize
                End If
                
                cbo_Cbo.AddItem ls_Description, cbo_Cbo.ListCount
                MCombo_LetCode(cbo_Cbo, cbo_Cbo.ListCount - 1) = ls_Code
                
                If lb_OldLoad = OK Then
                     
                    'drop flag
                    If li_colNumber > 2 And cbo_Cbo.ColumnCount > 2 Then
                        If ODBCData(ll_Statement, 3) = "X" Then
                            cbo_Cbo.Column(2, cbo_Cbo.ListCount - 1) = 1
                        Else
                            cbo_Cbo.Column(2, cbo_Cbo.ListCount - 1) = 0
                        End If
                    End If
                     
                    'icon ID
                    If li_colNumber > 3 And cbo_Cbo.ColumnCount > 3 Then
                        cbo_Cbo.Column(3, cbo_Cbo.ListCount - 1) = Val(ODBCData(ll_Statement, 4))
                    End If
                Else
                    
                    i = 2
                    
                    Do While i <= li_colNumber And cbo_Cbo.ColumnCount > i
                    
                        cbo_Cbo.Column(i, cbo_Cbo.ListCount - 1) = ODBCData(ll_Statement, i + 1)
                    
                        i = i + 1
                    
                    Loop
                    
                End If
            End If
        Loop
        
        'Verify if we must change the size of the combobox sublist
        If li_MaxSize > 0 Then cbo_Cbo.ListWidth = li_MaxSize + 25
      
        'Restore the parameters of the form
        cbo_Cbo.Parent.Font.Name = ls_Font
        cbo_Cbo.Parent.FontSize = li_FontSize
        cbo_Cbo.Parent.ScaleMode = li_ScaleMode
    End If
    
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    Exit Sub
    
suite:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
End Sub

Public Property Let MCombo_CodeSelect(cbo_Combo As msforms.ComboBox, lv_Code As Variant)
'------------------------------------------------------------------
' Name : MCombo_CodeSelect
'
' Purpose : Select the item by the code
'
' Parameters :
'       Cbo_combo       The comboBox
'       lv_code         The code to find
'
' Return : Nothing
'
' review : 15/Feb/2000 by AD
'------------------------------------------------------------------
Dim li_Count As Integer

On Error GoTo CodeSelect_Err

For li_Count = 0 To cbo_Combo.ListCount - 1
    If cbo_Combo.Column(1, li_Count) = lv_Code Then
        cbo_Combo.ListIndex = li_Count
        Exit Property
    End If
Next li_Count

CodeSelect_Err:
    cbo_Combo.ListIndex = -1
    
End Property

Public Property Let MCombo_TextSelect(cbo_Combo As msforms.ComboBox, lv_Text As Variant)
'------------------------------------------------------------------
' Name : MCombo_TextSelect
'
' Purpose : Select the item by the text
'
' Parameters :
'       Cbo_combo       The comboBox
'       lv_text         The Text to find
'
' Return : Nothing
'
' review : 15/Feb/2000 by AD
'------------------------------------------------------------------
Dim li_Count As Integer

On Error GoTo CodeSelect_Err

For li_Count = 0 To cbo_Combo.ListCount - 1
    If cbo_Combo.Column(0, li_Count) = lv_Text Then
        cbo_Combo.ListIndex = li_Count
        Exit Property
    End If
Next li_Count

CodeSelect_Err:
    cbo_Combo.ListIndex = -1
    
End Property

Public Property Get MCombo_GetCode(cbo_Combo As msforms.ComboBox) As Variant
'------------------------------------------------------------------
' Name : MCombo_GetCode
'
' Purpose : Return the code of the current item
'
' Parameters :
'       Cbo_combo       The comboBox
'
' Return : the code of the current item
'
' review : 15/Feb/2000 by AD
'------------------------------------------------------------------

    MCombo_GetCode = ""
    
    If cbo_Combo.ListIndex <> -1 Then
        MCombo_GetCode = cbo_Combo.Column(1)
    End If

End Property

Private Property Let MCombo_LetCode(cbo_Combobox As msforms.ComboBox, li_Index As Integer, lv_Code As Variant)
'------------------------------------------------------------------
' Name : MCombo_LetCode
'
' Purpose : Change the code of the current item
'
' Parameters :
'       Cbo_combo       The comboBox
'
' Return : Nothing
'
' review : 15/Feb/2000 by AD
'------------------------------------------------------------------

    cbo_Combobox.Column(1, li_Index) = lv_Code

End Property

Public Function MCombo_AddItemCode(cbo_Combobox As msforms.ComboBox, lv_Code As Variant, lv_Desc As Variant, Optional lb_Select = OK) As Boolean
'------------------------------------------------------------------
' Name : MCombo_AddItemCode
'
' Purpose : Add a new item in the combobox with a code and a
'           description. Change the size of the sublist if
'           necessary. Select the new item. Use this method
'           in general to add the item in update mode.
'
' Parameters :
'       Cbo_combo       The comboBox
'       lv_Code         the code of the new item
'       lv_Desc         the description of the new item
'       lb_Select       Select the added item
'
' Return : OK if added or KO if not
'
' review : 14/Mar/2000 by AD
'------------------------------------------------------------------
Dim ls_Font As String
Dim li_FontSize As String
Dim li_ScaleMode As Integer
Dim li_MaxSize As Integer
Dim li_CurrentSize As Integer
Dim li_ComboSize As Integer

    MCombo_AddItemCode = KO

    ls_Font = cbo_Combobox.Parent.Font.Name
    li_FontSize = cbo_Combobox.Parent.FontSize
    li_ScaleMode = cbo_Combobox.Parent.ScaleMode
    
    li_ComboSize = cbo_Combobox.Parent.ScaleX(cbo_Combobox.Width, vbTwips, vbPoints)
    cbo_Combobox.Parent.Font = cbo_Combobox.Font
    cbo_Combobox.Parent.FontSize = cbo_Combobox.Font.Size
    cbo_Combobox.Parent.ScaleMode = vbPoints
    
    li_MaxSize = CInt(Left(cbo_Combobox.ListWidth, Len(cbo_Combobox.ListWidth) - 3))
    If li_MaxSize > 0 Then li_MaxSize = li_MaxSize - 25
    
    li_CurrentSize = cbo_Combobox.Parent.TextWidth(lv_Desc)
    If (li_CurrentSize > li_MaxSize) _
      And (li_CurrentSize + 25 > li_ComboSize) Then
        li_MaxSize = li_CurrentSize
    End If

    If li_MaxSize > 0 Then cbo_Combobox.ListWidth = li_MaxSize + 25
    
    cbo_Combobox.Parent.Font.Name = ls_Font
    cbo_Combobox.Parent.FontSize = li_FontSize
    cbo_Combobox.Parent.ScaleMode = li_ScaleMode

    cbo_Combobox.AddItem lv_Desc, cbo_Combobox.ListCount
    MCombo_LetCode(cbo_Combobox, cbo_Combobox.ListCount - 1) = lv_Code

    If lb_Select = OK Then cbo_Combobox.ListIndex = cbo_Combobox.ListCount - 1

    MCombo_AddItemCode = OK

End Function
